/// \file cluster.h
/// \brief Definition of data structures and functions to handle clusters.
///    

#ifndef _cluster_h
#define _cluster_h

typedef struct _cluster_s Cluster;
typedef Cluster ClusterList;
typedef Cluster ClusterPos;

#include "residual_p_list.h"

/// \brief Data structure representing a cluster
///
/// A cluster of residuals linked by hydrogen bonds has a unique numerical index, 
/// the number of residuals included (detailed into solvents and solutes)
/// and a list (all together). It also has pointers to link the cluster into a list of clusters.

struct _cluster_s
{
  int Id;    ///<  Cluster identifier 

  int NumResiduals;   ///< Number of residuals included into the cluster
  int NumSolvents;    ///< Number of solvents included into the cluster
  int NumSolutes;     ///< Number of solutes included into the cluster
  pResidualList *PRL; ///< List of the residuals included into the cluster

  Cluster *next; ///< Pointer to the next     element in the list to which the cluster belongs (NULL if none)
  Cluster *prev; ///< Pointer to the previous element in the list to which the cluster belongs (NULL if none)
};

/// Create a new cluster structure with a given identifier

Cluster *createCluster (int Id);

#endif
