/// \file atom_list.h
/// \brief Definition of data structures and functions to handle lists of atoms.
///    

#ifndef _atom_list_h
#define _atom_list_h


#include "atom.h"

AtomList *createAtomList ();

void destroyAtomList (AtomList **pL);

AtomPos *firstAtomList (AtomList *L);

AtomPos *lastAtomList (AtomList *L);

boolean endAtomList (AtomPos *p, AtomList *L);

boolean emptyAtomList (AtomList *L);

AtomPos *nextAtomList (AtomPos *p);

void insAtomList (Atom *a, AtomPos *p);

void cancAtomList (AtomPos **p);

void appendAtomList (Atom *A, AtomList *L);

#endif
