/// \file atom_list.c
/// \brief Declaration of data structures and functions to handle lists of atoms.
///    

#include "atom_list.h"

AtomList *createAtomList ()
{
  AtomList *L = (AtomList *) malloc(sizeof(AtomList));
  if (L == NULL)
  {
    printf("Not enough memory to allocate a list of atoms!\n");
    exit(EXIT_MEMORY);
  }
  L->next = L;
  L->prev = L;
  return L;
}


void destroyAtomList (AtomList **pL)
{
  AtomPos *p;
  for (p = firstAtomList(*pL); !emptyAtomList(*pL); cancAtomList(&p));
  *pL = NULL;
}


AtomPos *firstAtomList (AtomList *L)
{
  AtomPos *p = L->next;
  return p;
}


AtomPos *lastAtomList (AtomList *L)
{
  AtomPos *p = L->prev;
  return p;
}


boolean endAtomList (AtomPos *p, AtomList *L)
{
  boolean b = (p == L);
  return b;
}


boolean emptyAtomList (AtomList *L)
{
  boolean b = (L->next == L) && (L->prev == L);
  return b;
}


AtomPos *nextAtomList (AtomPos *p)
{
  AtomPos *A = p->next;
  return A;
}


void insAtomList (Atom *A, AtomPos *p)
{
  A->prev = p->prev;
  A->next = p;
  A->prev->next = A;
  p->prev = A;
}


void cancAtomList (AtomPos **pp)
{
  AtomPos *A;
  A = *pp;
  A->prev->next = A->next;
  A->next->prev = A->prev;
  *pp = A->next;
  free(A);
}

void appendAtomList (Atom *A, AtomList *L)
{
    A->prev=L->prev;
    L->prev->next=A;
    L->prev=A;
    A->next=L;
} 

