/// \file atom.h
/// \brief Definition of data structures and functions to handle atoms.
///    
/// There is just the definition of an atom and its constructor.

#ifndef _atom_h
#define _atom_h

#include "defs.h"

typedef struct _atom_s Atom;  ///< External name to reference the structure modelling an atom
typedef Atom AtomList;        ///< External name to reference a list of atoms
typedef Atom AtomPos;         ///< External name to reference a cursor scanning a list of atoms

#include "residual.h"

/// \brief Data structure representing an atom
///
/// An atom is modelled as a point in a 3D space, with a unique numerical index and 
/// the label of its chemical element. It also has a pointer to get the residual including it
/// and pointers to link it to an atom list.

struct _atom_s
{
  
  int  Id;  ///<  Atom identifier 
  double x; ///< Spatial position (x coordinate in Angstrom)
  double y; ///< Spatial position (y coordinate in Angstrom)
  double z; ///< Spatial position (z coordinate in Angstrom)
  char Element[4]; ///< Chemical element
  Residual *R;     ///< Pointer to the residual to which the atom belongs (NULL if none)

  Atom *next; ///< Pointer to the next     element in the list to which the atom belongs (NULL if none)
  Atom *prev; ///< Pointer to the previous element in the list to which the atom belongs (NULL if none)
};

/// Create a new atom structure with given features
Atom *createAtom (int Id, double x, double y, double z, char *Element);

#endif
