/// \file residual_p_list.c
/// \brief Declaration of data structures and functions to handle lists of pointers to residuals.
///    

#include "residual_p_list.h"

pResidualList *createpResidualList ()
{
  pResidualList *L = (pResidualList *) malloc(sizeof(pResidualList));
  if (L == NULL)
  {
    printf("Not enough memory to allocate a list of pointers to residuals!\n");
    exit(EXIT_MEMORY);
  }
  L->next = L;
  L->prev = L;
  return L;
}


void destroypResidualList (pResidualList **pL)
{
  pResidualPos *p;
  for (p = firstpResidualList(*pL); !emptypResidualList(*pL); cancpResidualList(&p));
  *pL = NULL;
}


pResidualPos *firstpResidualList (pResidualList *L)
{
  pResidualPos *p = L->next;
  return p;
}


pResidualPos *lastpResidualList (pResidualList *L)
{
  pResidualPos *p = L->prev;
  return p;
}


boolean endpResidualList (pResidualPos *p, pResidualList *L)
{
  boolean b = (p == L);
  return b;
}


boolean emptypResidualList (pResidualList *L)
{
  boolean b = (L->next == L) && (L->prev == L);
  return b;
}


pResidualPos *nextpResidualList (pResidualPos *p)
{
  pResidualPos *M = p->next;
  return M;
}


void inspResidualList (pResidual *M, pResidualPos *p)
{
  M->prev = p->prev;
  M->next = p;
  p->prev->next = M;
  p->prev = M;
}

void cancpResidualList (pResidualPos **pp)
{
  pResidualPos *M;
  M = *pp;
  M->prev->next = M->next;
  M->next->prev = M->prev;
  *pp = M->next;
  free(M);
}

void appendpResidualList (pResidual *M, pResidualList *L)
{
    M->prev = L->prev;
    L->prev->next = M;
    L->prev = M;
    M->next = L;
}
