/// \file residual_list.h
/// \brief Definition of data structures and functions to handle lists of residuals.
///    

#ifndef _residual_list_h
#define _residual_list_h

#include "residual.h"

ResidualList *createResidualList ();

void destroyResidualList (ResidualList **pL);

ResidualPos *firstResidualList (ResidualList *L);

ResidualPos *lastResidualList (ResidualList *L);

boolean endResidualList (ResidualPos *p, ResidualList *L);

boolean emptyResidualList (ResidualList *L);

ResidualPos *nextResidualList (ResidualPos *p);

void insResidualList (Residual *M, ResidualPos *p);

void cancResidualList (ResidualPos **p);

void appendResidualList (Residual *M, ResidualList *L);

#endif
