/// \file residual_list.c
/// \brief Declaration of data structures and functions to handle lists of residuals.
///    

#include "residual_list.h"

ResidualList *createResidualList ()
{
  ResidualList *L = (ResidualList *) malloc(sizeof(ResidualList));
  if (L == NULL)
  {
    printf("Not enough memory to allocate a residual list!\n");
    exit(EXIT_MEMORY);
  }
  L->next = L;
  L->prev = L;
  return L;
}


void destroyResidualList (ResidualList **pL)
{
  ResidualPos *p;
  for (p = firstResidualList(*pL); !emptyResidualList(*pL); cancResidualList(&p));
  *pL = NULL;
}


ResidualPos *firstResidualList (ResidualList *L)
{
  ResidualPos *p = L->next;
  return p;
}


ResidualPos *lastResidualList (ResidualList *L)
{
  ResidualPos *p = L->prev;
  return p;
}


boolean endResidualList (ResidualPos *p, ResidualList *L)
{
  boolean b = (p == L);
  return b;
}


boolean emptyResidualList (ResidualList *L)
{
  boolean b = (L->next == L) && (L->prev == L);
  return b;
}


ResidualPos *nextResidualList (ResidualPos *p)
{
  ResidualPos *M = p->next;
  return M;
}


void insResidualList (Residual *M, ResidualPos *p)
{
  M->prev = p->prev;
  M->next = p;
  p->prev->next = M;
  p->prev = M;
}

void cancResidualList (ResidualPos **pp)
{
  ResidualPos *M;
  M = *pp;
  M->prev->next = M->next;
  M->next->prev = M->prev;
  *pp = M->next;
  free(M);
}

void appendResidualList (Residual *M, ResidualList *L)
{
    M->prev=L->prev;
    L->prev->next=M;
    L->prev=M;
    M->next=L;
}    

