/// \file residual.c
/// \brief Declaration of data structures and functions to handle residuals.
///    

#include "residual.h"

/// Create a new residual
Residual *createResidual (int Id, char *Substance)
{
  Residual *R = (Residual *) malloc(sizeof(Residual));
  if (R == NULL)
  {
    printf("Not enough memory to allocate residual %d!\n",Id);
    exit(EXIT_MEMORY);
  }

  R->Id = Id;
  strcpy(R->Substance, Substance);
  R->NumHydBonds = 0;
  R->BL = createHydBondList();
  R->ADL = createAtomList();
  R->HL = createAtomList();
  R->OL = createAtomList();
  R->next = R->prev = NULL;
  R->C = NULL;
  return R;
}


/// The residual is emptied (all fields zeroed), but not destroyed!
void emptyResidual (Residual *R)
{
  R->Id = 0;
  strcpy(R->Substance,"");
  R->NumHydBonds = 0;
  destroyHydBondList(&R->BL);
  destroyAtomList(&R->ADL);
  destroyAtomList(&R->HL);
  destroyAtomList(&R->OL);
  R->C = NULL;
}
