/// \file hydbond_list.h
/// \brief Definition of data structures and functions to handle lists of hydrogen bonds.
///    

#ifndef _hydbond_list_h
#define _hydbond_list_h

#include "hydbond.h"

HydBondList *createHydBondList ();

void destroyHydBondList (HydBondList **pL);

void insHydBondList (HydBond *l, HydBondPos *p);

HydBondPos *firstHydBondList (HydBondList *L);

HydBondPos *lastHydBondList (HydBondList *L);

boolean endHydBondList (HydBondPos *p, HydBondList *L);

boolean emptyHydBondList (HydBondList *L);

HydBondPos *nextHydBondList (HydBondPos *p);

void cancHydBondList (HydBondPos **p);

void appendHydBondList (HydBond *Lg, HydBondList *Ll);

#endif
