/// \file hydbond_list.c
/// \brief Declaration of data structures and functions to handle lists of hydrogen bonds.
///    

#include "hydbond_list.h"


HydBondList *createHydBondList ()
{
  HydBondList *L = (HydBondList *) malloc(sizeof(HydBondList));
  if (L == NULL)
  {
    printf("Not enough memory to allocate a hydrogen bond list!\n");
    exit(EXIT_MEMORY);
  }
  L->next = L;
  L->prev = L;
  return L;
}


void destroyHydBondList (HydBondList **pL)
{
  HydBondPos *p;
  for (p = firstHydBondList(*pL); !emptyHydBondList(*pL); cancHydBondList(&p));
  *pL = NULL;
}


HydBondPos *firstHydBondList (HydBondList *L)
{
  HydBondPos *p = L->next;
  return p;
}


HydBondPos *lastHydBondList(HydBondList *L)
{
  HydBondPos *p = L->prev;
  return p;
}


boolean endHydBondList (HydBondPos *p, HydBondList *L)
{
  boolean b = (p == L);
  return b;
}


boolean emptyHydBondList (HydBondList *L)
{
  boolean b = (L->next == L) && (L->prev == L);
  return b;
}


HydBondPos *nextHydBondList (HydBondPos *p)
{
  HydBondPos *L = p->next;
  return L;
}


void insHydBondList (HydBond *L, HydBondPos *p)
{
  L->prev = p->prev;
  L->next = p;
  L->prev->next = L;
  p->prev = L;
}


void cancHydBondList (HydBondPos **pp)
{
  HydBondPos *L;
  L = *pp;
  L->prev->next = L->next;
  L->next->prev = L->prev;
  *pp = L->next;
  free(L);
}

void appendHydBondList (HydBond *Lg, HydBondList *Ll)
{
    Lg->prev=Ll->prev;
    Ll->prev->next=Lg;
    Ll->prev=Lg;
    Lg->next=Ll;
} 
 
 

