/// \file hydbond.c
/// \brief Declaration of data structures and functions to handle hydrogen bonds.
///    

#include "hydbond.h"

HydBond *createHydBond (int Id, double Distance, double Angle, Atom *A, Atom *D, Atom *H, Residual *DonRes, Residual *AccRes)
{
  HydBond *B = (HydBond *) malloc(sizeof(HydBond));
  if (B == NULL)
  {
    printf("Not enough memory to allocate hydrogen bond %d!\n",Id);
    exit(EXIT_MEMORY);
  }

  B->Id = Id;
  B->Distance = Distance;
  B->Angle = Angle;
  B->A = A;
  B->D = D;
  B->H = H;
  B->prev = B->next = B->opposite = NULL;
  B->DonRes = DonRes;
  B->AccRes = AccRes;
  return B;
}

