/// \file defs.h
/// \brief Definition of global constants and types.
///    

#ifndef _defs_h
#define _defs_h

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

/// Exit codes of the program
#ifndef EXIT_CODES
  #define EXIT_CODES
  #define EXIT_SUCCESS          0  ///< Correct termination
  #define EXIT_WRONGCOMMANDLINE 1  ///< Incorrect command line 
  #define EXIT_MEMORY           2  ///< Insufficient memory
  #define EXIT_OPENFILE         3  ///< Error while opening a file
  #define EXIT_WRONGINPUTFORMAT 4  ///< Incorrect format in an input file
  #define EXIT_INCONSISTENCY    5  ///< Inconsistency in the data structures
#endif

// Type definition for boolean variables and functions
#ifndef _boolean
  #define _boolean
  typedef short int boolean;
  #define TRUE  1
  #define FALSE 0
#endif

// Length of the input file name
#define LUNGHEZZA   80

/*
#define LETTERE_INTESTAZIONE_ATOM 4
#define LETTERE_TIPO_CLUSTER 9
#define NUMERO_ATOMI 6
#define TIPO_ATOMI 2
#define TIPO_MOLECOLE 3
#define NUMERO_MOLECOLE 6
#define CIFRE_POSIZIONE 6
#define CIFRE_ALTRO 6
*/

#endif
