/// \file cluster_list.c
/// \brief Declaration of data structures and functions to handle lists of clusters.
///    

#include "cluster_list.h"

ClusterList *createClusterList ()
{
  ClusterList *L = (ClusterList *) malloc(sizeof(ClusterList));
  if (L == NULL)
  {
    printf("Not enough memory to allocate a cluster list!\n");
    exit(EXIT_MEMORY);
  }
  L->next = L;
  L->prev = L;
  return L;
}


void destroyClusterList (ClusterList **pL)
{
  ClusterPos *p;
  for (p = firstClusterList(*pL); !emptyClusterList(*pL); cancClusterList(&p));
  *pL = NULL;
}


ClusterPos *firstClusterList (ClusterList *L)
{
  ClusterPos *p = L->next;
  return p;
}


ClusterPos *lastClusterList (ClusterList *L)
{
  ClusterPos *p = L->prev;
  return p;
}


boolean endClusterList (ClusterPos *p, ClusterList *L)
{
  boolean b = (p == L);
  return b;
}


boolean emptyClusterList (ClusterList *L)
{
  boolean b = (L->next == L) && (L->prev == L);
  return b;
}


ClusterPos *nextClusterList (ClusterPos *p)
{
  ClusterPos *C = p->next;
  return C;
}


void insClusterList (Cluster *C, ClusterPos *p)
{
  C->prev = p->prev;
  C->next = p;
  p->prev->next = C;
  p->prev = C;
}

void cancClusterList (ClusterPos **pp)
{
  ClusterPos *C;
  C = *pp;
  C->prev->next = C->next;
  C->next->prev = C->prev;
  *pp = C->next;
  free(C);
}

void appendClusterList (Cluster *C, ClusterList *L)
{
    C->prev=L->prev;
    L->prev->next=C;
    L->prev=C;
    C->next=L;
}    

