/// \file cluster.c
/// \brief Declaration of data structures and functions to handle clusters.
///    

#include "cluster.h"

Cluster *createCluster (int Id)
{
  Cluster *C = (Cluster *) malloc(sizeof(Cluster));
  if (C == NULL)
  {
    printf("Not enough memory to allocate cluster %d!\n",Id);
    exit(EXIT_MEMORY);
  }

  C->Id = Id;
  C->next = C->prev = NULL;
  C->PRL = createpResidualList();
  C->NumResiduals = 0;
  C->NumSolvents = 0;
  C->NumSolutes = 0;
  return C;
}
