/// \file atom.c
/// \brief Declaration of data structures and functions to handle atoms.
///    
/// There is just the definition of an atom and its constructor.

#include "atom.h"

/// Create a new atom structure with given features
Atom *createAtom (int Id, double x, double y, double z, char *Element)
{
  Atom *A = (Atom *) malloc(sizeof(Atom));
  if (A == NULL)
  {
    printf("Not enough memory to allocate atom %d!\n",Id);
    exit(EXIT_MEMORY);
  }

  A->Id = Id;
  A->x = x;
  A->y = y;
  A->z = z;
  strcpy(A->Element, Element);
  A->R = NULL;
  A->next = A->next = NULL;

  return A;
}
