# -*- coding: utf-8 -
"""
Codice per la gestione di client paralleli che chiedono al server di scrivere dati
"""
import socket
import random
import threading

class Writer(threading.Thread):
	"""
	Scrittore che estende la classe Thread e permette quindi l'esecuzione di codice in parallelo.
	"""
	def __init__(self,nome):
		"""
		Costruttore della classe Writer.
		"""
		super(Writer,self).__init__() # Richiama il costruttore della classe padre (Thread). Necessario per inizializzare tutte le proprietà ereditate.
		self.nome = nome
		
	def run(self):
		"""
		Metodo eseguito in un thread parallelo quando viene richiamato il metodo start().
		Finché non ci sono errori, invia al server un numero da inserire nel buffer.
		Termina quando il buffer è pieno e il server chiude la connessione (generando un'eccezione lato client).
		"""
		try:
			while True:
				s = socket.socket(socket.AF_INET)
				s.connect(('localhost',8001))
				num = random.randrange(1,10)
				s.sendall(bytes(str(num),'UTF-8'))
				print("{} invia {}".format(self.nome, num))
				s.close()
		except Exception as e:
			print("{} invio terminato: {}".format(self.nome, e))
		

if __name__ == '__main__':
	# Creo 3 scrittori che eseguono in parallelo il metodo run()
	Writer('C1').start()
	Writer('C2').start()
	Writer('C3').start()
	

