;; Implementazione (scopo didattico!!!) di MERGESORT

(define (sortedmerge xs ys)
  (cond ( (null? xs) ys )
        ( (null? ys) xs )
        ( (< (car xs) (car ys))
          (cons (car xs) (sortedmerge (cdr xs) ys)))
        ( else
          (cons (car ys) (sortedmerge xs (cdr ys)))
        )
  )
)

(define (filter fun lst)
  (if (null? lst) '()
  (if (fun (car lst)) (cons (car lst) (filter fun (cdr lst))) 
      (filter fun (cdr lst))
      )
  )
)

(define (split p lst)
  (values (filter (lambda (x) (< x p)) lst)
          (filter (lambda (x) (>= x p)) lst)
   )
  )

(define (mergesort lst)
  ( if (null? lst) '()
  (let-values ([(l g) (split (car lst) (cdr lst))])
    (sortedmerge (mergesort l) (cons (car lst) (mergesort g)))
  )
  )
)

