;; Fibonacci semplice

(define (fib n)
  (if (< n 2) 1 (+ (fib (- n 1)) (fib (- n 2))))
)

;; Fibonacci con accumulatore (environment a)

(define (afib n a)
  (if (< n 2) (add_env a n 1) 
      (if (find_env a n) a
          (let* ( (r1 (afib (- n 1) a))
                  (r2 (afib (- n 2) r1))
                      )
                   (add_env r2 n (+ (find_env r1 (- n 1)) (find_env r2 (- n 2))))
                    
                   )
      )
  )
)

;; environment implementato come lista di elementi <chiave, valore>

(define (create_env) '())
(define (add_env env k v) (cons (list k v) env))
(define (find_env env k) 
  (if (null? env) #f 
      (if (eq? (caar env) k) (cadar env) (find_env (cdr env) k))
   )
)

;; environment implementato come funzione: v = env(x) riceve una chiave x e restituisce un valore v

;;(define (create_env) (lambda (x) #f ))
;;(define (add_env env k v) (lambda (x) (if (eq? x k) v (env x))))
;;(define (remove_env env k) (lambda (x) (if (eq? x k) #f (env x))))
;;(define (find_env env k) (env k))

;;(define e (create_env))
