class Stack_iterator:
	def __init__(self, in_items, in_cnt):
		self.items = in_items
		self.cnt = in_cnt - 1
		self.current = -1

	def __iter__(self):
		return self

	def next(self):
		if (self.current >= self.cnt) :
			raise StopIteration
		else :
			self.current = self.current + 1
			return self.items[self.current]


class Stack :
  def __init__(self) :
    self.items = []
    self.__cnt = 0

  def top(self) :
    return (self.items[self.__cnt - 1])

  def push(self, item) :
    self.items.append(item)
    self.__cnt = self.__cnt + 1

  def pop(self) :
    self.__cnt = self.__cnt - 1
    return self.items.pop()

  def empty(self) :
    return (self.items == [])

  def iter(self) :
    return Stack_iterator(self.items,self.__cnt)
