% Notazione lista: sequenza di elementi (omogenei)
lista([a,b,c,d]).
% Notazione lista: sequenza di elementi (non omogenei)
lista([a,1,c,2]).
%% def ricorsiva di lista: 
% [] e' una lista
lista([]).
% [X|Lista] e' una lista
lista([_|Y]) :- lista(Y).

membr(X,[X|Ys]). % domanda: member(_,[_,Ys]). e' equivalente?
membr(X,[_|Ys]) :- membr(X, Ys).

suffix(X, X).
suffix(X, [_|Ys]) :- suffix(X,Ys).

prefix([],_).
prefix([X|Xs],[X|Ys]) :- prefix(Xs,Ys).

appnd([],Ys,Ys).
appnd([X|Xs],Ys,[X|Rs]) :- appnd(Xs,Ys,Rs).

delt(_,[],[]).
delt(X,[X|Ys],R) :- delt(X,Ys,R).
delt(X,[Y|Ys],[Y|Rs]) :- X \= Y, delt(X,Ys,Rs).

mdelete([],Ys,Ys).
mdelete([X|Xs],Ys,Rs) :- delt(X,Ys,Ts), mdelete(Xs,Ts,Rs).

idelt(_,[],[]).
idelt(X,[Y|Ys],[Y|Rs]) :- idelt(X,Ys,Rs).
idelt(X,[X|Ys],R) :- idelt(X,Ys,R), !.

imdelete([],Ys,Ys).
imdelete([X|Xs],Ys,Rs) :-  mdelete(Xs,Ys,Ts), idelt(X,Ts,Rs).

revrs([],[]).
revrs([X|Xs], Ys) :- revrs(Xs, Rs) , appnd(Rs,[X],Ys).

checkapple([]).
checkapple([apple(_)|Xs]) :- checkapple(Xs).
