range(M,N,[M|Ns]) :- M < N, MM is M + 1, range(MM, N ,Ns).
range(N, N, [N]).

permutation([],[]).
permutation([X|Xs],Ys) :- %member(X,Ys), 
	select(X,Ys,Rs), 
	permutation(Xs,Rs).

attack(Q1,Qs) :- attack(Q1,1,Qs). 
attack(Q1,N,[Q2|_]) :- Q1 is Q2 + N ; Q1 is Q2 - N.
attack(Q1,N,[_|Qs]) :- NN is N+1, attack(Q1,NN,Qs).

safe([]).
safe([_]).
safe([Q1|Qs]) :- safe(Qs), not(attack(Q1,Qs)).

queens(N, Qs) :- range(1,N,P), permutation(Qs,P), safe(Qs).


queen_permutation([],Placed,Placed).
queen_permutation(Unplaced, Placed, Qs) :- 
	select(Q, Unplaced, Rs), 
	not(attack(Q,Placed)),
	queen_permutation(Rs, [Q|Placed], Qs).


nqueens(N, Qs) :- range(1,N,P), queen_permutation(P, [], Qs).
