members([],_).
members([X|Xs],Ys) :- member(X,Ys), members(Xs,Ys).


regioncolor( region(_,Color,Neigh), Colors ) :-
	select(Color, Colors, UsedCols),
	members(Neigh, UsedCols).

mapcolor([],_).
mapcolor([Region|Regions],Colors) :-
	regioncolor(Region,Colors),
	mapcolor(Regions,Colors).

run(I,F,S,A) :- mapcolor(
[
region(italy,I,[F,S,A]),
region(france,F,[I,S]),
region(swiss,S,[F,I,A]),
region(austria,A,[S,I])
],
[white, red, blue, yellow]
).

