;; FUNZIONI COME PARAMETRI IN INPUT

(define (ctrl-alias fun lst)
  (if (null? lst) '() (fun lst))
  )

(define (compare-elements rel lst1)
  (if (null? (cdr lst1)) #t
      (if (rel (car lst1) (cadr lst1)) (compare-elements rel (cdr lst1)) #f)
      )
  )
  
;; FUNZIONI COME PARAMETRI IN OUTPUT (funzioni che costruiscono funzioni)

(define (simple-replace a b x)
  (if (eq? x a) 
                   b 
                   x
  )
)

(define repi ( lambda (x)
                     (simple-replace 1 2 x)
                   )
  )

(define (rep a b)
  (lambda (x) ( (if (eq? x a) 
                   b 
                   x
                   )
               )
    )
)
 
(define (ctrl-ubounds M i)
  (if (> i M) M i)
)
(define (ctrl-lbounds m i)
  (if (< i m) m i)
)
(define (ctrl-ulbounds U L i) (ctrl-ubounds U (ctrl-lbounds L i)))
  
;; FUNZIONI CHE RESTITUISCONO PIU' DI UN ARGOMENTO

(define (go-to-values a b) (values a b))
;(define (get-and-sum a b)
;  (let-values ((a b) (get-and-sum a b)) (+ a b)))
(define v (
             let-values ([(x y) (go-to-values 1 2)])
              (+ x y)
              )
)

;; FUNZIONI CON UN NUMERO VARIABILE DI ARGOMENTI IN INPUT


(define (last . args) 
  (if (null? args) 3 '(1 2 3))
  )

(define (l-summation lst) 
  (if
   (null? lst) 0
   (+ (car lst) (l-summation (cdr lst)))
   )
  )

(define (summation . args)
  (if
   (null? args) 0
   (l-summation args)
   )
  )
