package body ProducerConsumerBuffer is

	task body DataBuffer is

		buffersize : constant Integer := 100;
		buffer : array (1 .. buffersize) of Integer;
		filled : Integer range 0 .. buffersize := 0;
		next_in, next_out : Integer range 1 .. buffersize := 1;

	begin
		loop
			select

			  when filled < buffersize =>
			    accept Put(item : in Integer) do
				buffer(next_in) := item;
			    end Put;
			    next_in := (next_in mod buffersize) + 1;
			    filled := filled + 1;

			or

			  when filled > 0
			    accept Get(item : out Integer) do
				item := buffer(next_out);
			    end Get;
			    next_out := (next_out mod buffersize) + 1;
			    filled := filled - 1;

			end select;
		end loop;

	end DataBuffer;

	task body Producer is
		new_value : Integer;
		databuffer : DataBuffer;
	begin
	   loop
		-- produce new_value --
		databuffer.Put(new_value);
	   end loop;
	end Producer;

	task body Consumer is
		stored_value : Integer;
		databuffer : DataBuffer;
	begin
	   loop
		databuffer.Get(stored_value);
		-- consume stored_value --
	   end loop;
	end Producer;

end ProducerConsumerBuffer;
