public class SBuffer extends Buffer {

	TQueue readers;
	TQueue writers;
	TQueue lock;

	public SBuffer(int MAX_ITEMS) {
		
		super(MAX_ITEMS);

		readers = new TQueue(0);
		writers = new TQueue(MAX_ITEMS);
		lock = new TQueue();

	}

	public int pop() {

		try{
			readers.acquire();
			lock.acquire();
		} catch (InterruptedException e) {System.out.println("Pop Finishing"); }
	

		int v = super.pop();

		lock.release();
		writers.release();

		return v;
	}

	public void push(int i) {

		try {
			writers.acquire();
			lock.acquire(); 
		} catch (InterruptedException e) {System.out.println("Push Finishing"); }


		super.push(i);

		lock.release();
		readers.release();

	}

}
