#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>

// SSS -> out of scope (compile time errors)
// MMM -> invalid address (runtime errors)
// PPP -> pointers arithmetic hacks

typedef struct {
	int start;
	int end;
	int result;
} thread_args;

int * A_local_address;

void * runnerA(void * param);
void * runnerB(void * param);

int main(int argc, char * argv[]) {
pthread_t tid_A;
pthread_attr_t attr_A;

pthread_t tid_B;
pthread_attr_t attr_B;


size_t stacksize;

	// MMM (likely) invalid memory access
	// A_local_address = 0;
	// *A_local_address = 10;

	pthread_attr_init(&attr_A);
	pthread_attr_init(&attr_B);

	pthread_attr_getstacksize(&attr_A, &stacksize);
	printf("Thread stack size: %zu\n",stacksize);
	// uncomment the following two lines and see the output:
	// each thread has its own reserved space for stack
	// stacksize = stacksize * 2;	
	// pthread_attr_setstacksize(&attr_A, stacksize);


	pthread_create(&tid_A, &attr_A, runnerA, NULL);
	// SSS out of scope:
	// A_i = 10;	

	pthread_create(&tid_B, &attr_B, runnerB, NULL);

	pthread_join(tid_A, NULL);
	pthread_join(tid_B, NULL);


	return(EXIT_SUCCESS);
	
}

void * runnerA(void * param) {
int A_i;

	printf("A stack begin: %p\n",&A_i);
	
	A_i = 0;
	printf("initial i %d\n", A_i);

	// PPP pointers arithmetic eludes scoping 
	A_local_address = &A_i;

	usleep(1000);
	
	printf("final i %d\n", A_i);

	pthread_exit(0);
}

void * runnerB(void * param) {
int B_i;

	printf("B stack begin: %p\n",&B_i);

	// SSS out of scope:
	// A_i = 10;
	
	usleep(500);
	*A_local_address = 10;

	pthread_exit(0);
}
