#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <stdio.h>
#include <string.h>

#define MSGSZ     128


/*
 * Declare the message structure.
 */

typedef struct msgbuf {
         long    mtype;
         char    mtext[MSGSZ];
} message_buf;

main()
{
    int msqid;
    int msgflg = IPC_CREAT | 0666;
    key_t key;
    message_buf sbuf;
    size_t buf_length;

    /*
     * Get the message queue id for the
     * "name" 1234, which was created by
     * the server.
     */
    key = 1234;

    fprintf(stderr, "\nmsgget: Calling msgget(%#lx,\ %#o)\n", key, msgflg);

    // msgget(<key>, <flags>) --> returns queue id
    if ((msqid = msgget(key, msgflg )) < 0) {
        perror("msgget");
        exit(1);
    } else 
	fprintf(stderr,"msgget: msgget succeeded: msqid = %d\n", msqid);

    printf("Enter character to send: ");
    char v = getchar();

    /*
     * We'll send message type 1
     */
     
    sbuf.mtype = 1;
    sprintf(sbuf.mtext, "I'm sending you this %c.\n",v);
    buf_length = strlen(sbuf.mtext) + 1 ;
    
    /*
     * Send a message.
     */
    fprintf(stderr,"About to send a message on queue id %d\n", msqid);
    // msgsnd(<queue id>, <pointer to message buffer>, <message length>, <flags>) --> error code
    // FAILS if the queue is full:
    // if (msgsnd(msqid, &sbuf, buf_length, IPC_NOWAIT) < 0) {
    // SYNCHRONOUS: waits if the queue is full
    if (msgsnd(msqid, &sbuf, buf_length, 0) < 0) {
       printf ("Problem sending: %d, %d, %s, %l\n", msqid, sbuf.mtype, sbuf.mtext, buf_length);
       perror("msgsnd");
       exit(1);
    }
    
    printf("Message: \"%s\" Sent!\n", sbuf.mtext);
    
      
    exit(0);
}
