param n;
param m;

set V := 1 .. n;
set K := 1 .. m;
set A within {V cross V};

param c{A,K};
param b{V,K};
param u{A};

param lambda{A} default 0;

param s;
param t;

var x{(i,j) in A,k in K} >= 0, <= u[i,j];

minimize v: sum{(i,j) in A, k in K} c[i,j,k] * x[i,j,k];
subject to flowcons{i in V, k in K}: sum{(l,j) in A: l == i} x[i,j,k] = sum{(j,l) in A: l == i} x[j,i,k] + b[i,k];
subject to cap{(i,j) in A}: sum{k in K} x[i,j,k] <= u[i,j];

minimize lr_v: sum{(i,j) in A, k in K} c[i,j,k] * x[i,j,k] - sum{(i,j) in A} lambda[i,j] * ( - sum{k in K} x[i,j,k] + u[i,j]);

problem mmcf: v, flowcons, cap, x;
problem lr_mmcf{k in K}: lr_v, {i in V}flowcons[i,k], {(i,j) in A}x[i,j,k];
