param n;
param m;

set V := 1 .. n;
set K := 1 .. m;
set A within {V cross V};

param p{K} default 1;
set P{k in K} := 1 .. p[k];

param c{A,K};
param b{V,K};
param u{A};

param d{i in V,k in K} := 
	if (b[i,k] > 0) then 1 
	else  
		if (b[i,k] < 0) then -1 
		else 0;


param lambda{A} default 0;
param mu{K} default 0;

param s;
param t;

param a{A,k in K,P[k]} default 0;
var f{k in K, P[k]} >=0;

var dummy{K} >= 0;

minimize master: sum{k in K} 10000 * dummy[k] + sum{k in K} sum{q in P[k]} (sum{(i,j) in A} c[i,j,k] * a[i,j,k,q]) * f[k,q];
subject to cap{(i,j) in A}: sum{k in K, q in P[k]} - a[i,j,k,q] * f[k,q] >= - u[i,j];
subject to flow{k in K}: dummy[k] + sum{q in P[k]} f[k,q] >= sum{i in V: b[i,k] > 0} b[i,k];


var x{A} >=0, <=1;
minimize rc{k in K}: sum{(i,j) in A} (c[i,j,k] + lambda[i,j]) * x[i,j] - mu[k];
subject to flowcons{k in K, i in V}: sum{(l,j) in A: l == i} x[i,j] = sum{(j,l) in A: l == i} x[j,i] + d[i,k];

problem RMP: master, cap, flow, f, dummy;
problem PP{k in K}: rc[k], {i in V}flowcons[k,i], x;
