; (A) provide an interface
; 'hello' will become the name of a class
(ns test.hello
    (:gen-class
	; list of class methods
	:methods [[nfact [int] int]])
	)

; (B) implement internal (say "private" functions)
; they can have any name
(defn funnyfact 
	[n]
	(if (= n 0) 1 (* n (funnyfact (- n 1))))
)

; (C) implement the methods in the interface (remember to put a dash "-" before the method name)
; i.e. nfact in the interface -> -nfact in the implementation
; each function will have an additional argument (this) pointing to the instance calling the method
(defn -nfact [this n] 
	( funnyfact n )
)

; (D) (possibly) provide a main ...
; here we use a Java Math library function (i.e. Java bytecode) inside Clojure code
(defn -main
  [f]
  (println (str "Hello ACP! Rounding " f " to " (Math/floor (Float/parseFloat f)) " !"))
)

; I can also use Java Data Structures: 
;(def s (java.util.Stack.))
;(def t (.push s 42))
;(.push t 50)
;(println (.peek s))
;(doto s (.pop) (.pop))

;(compile 'hello)
