
// Say I want to be more specific: I can assign an "upper bound"
// to type parameter T in the Java classes hierarchy.
// In this case T must always be "subclass" of Comparable (see StackMain for example of compile time error).
// By "subclass" we include also "implements" (i.e. simulation of multiple inheritance) ...
class Stack<T extends Comparable> {

	// Properties
	protected T[] stackStorage;
	protected int stackTopPointer;

	// Methods
	
	public Stack(int myMaxStackDim) {

		// In our code we can use the more specific type bound
		//stackStorage = (T[]) new Object [myMaxStackDim];
		stackStorage = (T[]) new Comparable [myMaxStackDim];
		stackTopPointer = 0;

	}

	public void push(T elem) {
		
		if (stackTopPointer < stackStorage.length)
			stackStorage[ stackTopPointer++ ] = elem;
	}

	public void pop() {
		if (stackTopPointer > 0) stackTopPointer--;
	}

	public T top() {
		if (stackTopPointer > 0) 
			return stackStorage[ stackTopPointer -1 ];
		else
			return (T) null;
	}

	public boolean empty() {
		return (stackTopPointer == 0);
	}

}
