import java.io.*;

class DisplayIntStack extends IntStack {

	public DisplayIntStack(int myMaxStackDim) {
		super(myMaxStackDim);
	}
	
	// Overriding
	public void pop() {
		// subclass specific code:
		System.out.println("Warning: pop out an element: " + stackTopPointer + " remaining");
		// then we can even call superclass' version
		//if (stackTopPointer > 0) stackTopPointer--;
		super.pop();
	}
	
	// Overloading with static binding
	final public void pop(int t) {
		// method specific code:
		if (stackTopPointer <= t) System.out.println("Warning: pop out an element: " + stackTopPointer + " remaining");
		// then we can also call another version of the method
		// pop(); // calls pop() method with no arguments of DisplayIntStack
		if (stackTopPointer > 0) stackTopPointer--;
	}

	// still static binding
	public static void info() {
		System.out.println("I am a DisplayIntStack!");
	}

	public void display() {
		for (int i = 0; i<stackTopPointer; i++) System.out.println("Elem " + i + " " + stackStorage[i]);
	}

}
