import java.io.*;

public class StackMain {

	public static void main(String[] args) {
	Stack<Integer> myStack = new Stack<Integer>(100);
	
		if (args.length <= 0) return;

		for (int i = 0; i<Integer.parseInt(args[0]); i++) myStack.put(i);
	
		// Example on using iterators in a while loop
		MIterator<Integer> iter = myStack.iterator();
		while(! iter.is_end() ) {
			System.out.println("Stack iter is:" +  iter.get() );
			iter.next();
		}
		
		// Example on using iterators in a for loop
		for (MIterator<Integer> t = myStack.iterator(); ! t.is_end(); t.next()) {
			System.out.println("item: " + t.get());
		}

		// Example of using generic code
		GenericComputing<Integer> f = new GenericComputing<Integer>();	
		System.out.println("Calling FindMax: " +  f.findMax(myStack) );
		System.out.println("Calling FindMin: " +  f.findMin(myStack) );
		
		while ( ! myStack.empty() ) {
			System.out.println("Stack top is:" +  myStack.top() );
			myStack.pop();
		}

		return;
		
	}
}

