// now, Stack is a Container
class Stack<T extends Comparable> implements MContainer<T> {

	// Properties
	protected T[] stackStorage;
	protected int stackTopPointer;

	// First, be compliant with MContainer
	// public T get();
	// public void put(T data);
	// public MIterator iterator();

	// MIterator is an interface, an implementation of iterator() must return an implementation of MIterator
	// Let's define it here: no need outside of Stack class
	protected class StackIterator<T extends Comparable> implements MIterator<T> {

		// the implementation details are not the key point
		// ... but ... here the idea is to give to the Iterator a pointer to the whole stack
		protected int t;
		protected Stack<T> stack;

		public StackIterator(Stack<T> in) {
			stack = in;
			t = 0;
		}
		public void next() {
			t++;
		}

		public boolean is_end() {
			if (t == stack.stackTopPointer) return true;
			else return false;
		}

		public T get() {
			return stack.stackStorage[t];
		}
	}

	public T get() {
		if (stackTopPointer > 0) stackTopPointer--;
		return stackStorage[ stackTopPointer ];
	}
	
	public void put(T elem) {
		if (stackTopPointer < stackStorage.length)
			stackStorage[ stackTopPointer++ ] = elem;
	}
	
	public StackIterator iterator() {
		return new StackIterator(this);
	}

	// Then, add further class code ...
	public Stack(int myMaxStackDim) {

		stackStorage = (T[]) new Comparable [myMaxStackDim];
		stackTopPointer = 0;

	}

	public void pop() {
		if (stackTopPointer > 0) stackTopPointer--;
	}
	

	public T top() {
		if (stackTopPointer > 0) 
			return stackStorage[ stackTopPointer -1 ];
		else
			return (T) null;
	}

	public boolean empty() {
		return (stackTopPointer == 0);
	}

}
