library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity cnt2bitud_tb is
end entity cnt2bitud_tb;

architecture arch of cnt2bitud_tb is

    -- component to test
component cnt2bitud is
port( clk  :  in std_logic;
reset  :  in std_logic;
up  :  in std_logic;
cnt  :  out std_logic_vector(1 downto 0));
end component;

    -- signal to map to component
signal clk : std_logic := '1';
 signal  reset : std_logic := '1';
 signal  up : std_logic;
 signal  cnt : std_logic_vector(1 downto 0);

begin
    -- map signals
    uut: cnt2bitud port map ( clk=>clk,
				reset=>reset,
				up=>up,
				cnt=>cnt);

    process is 
    begin
	    clk <= not clk;
	    wait for 5 ns;
    end process;

    stimulus: process is
    begin
     -- write your test here
	    reset <= '0';
	    wait for 4 ns;
	    reset <= '1';
	    up <= '1';
	    wait for 36 ns;
	    up <= '0';
	    wait for 40 ns;
    wait;
    end process;
end architecture;
    
