library ieee;
use ieee.std_logic_1164.all;

-- 2 bit up up/down counter:
entity cnt2bitud is
	port( clk : in std_logic;
	      reset : in std_logic;
	      up : in std_logic;
	      cnt : out std_logic_vector(1 downto 0));
end entity;

architecture arch of cnt2bitud is
	type state is (C0, C1, C2, C3);
	signal current_state, next_state : state;
begin
	--------------------------------------------
	STATE_MEMORY : process(clk, reset) is
	begin
		if(reset = '0') then
			------ YOUR CODE HERE ------
			
			----------------------------
		elsif(rising_edge(clk)) then
			current_state <= next_state;
		end if;
	end process;
	--------------------------------------------
	NEXT_STATE_LOGIC : process(current_state, up) is
	begin
		case(current_state) is
			------ YOUR CODE HERE -----------

			---------------------------------
			when C2 => if(up = '1') then 
				   	next_state <= C3;
				   else
					next_state <= C1;
				   end if;
			when C3 => if(up = '1') then
				   	next_state <= C0;
				   else
					next_state <= C2;
				   end if;
			when others => next_state <= C0;
		end case;
	end process;
	--------------------------------------------
	OUTPUT_LOGIC : process(current_state) is
	begin -- FSM type : Moore. Output is state coded 
		case(current_state) is
			when C0 => cnt <= "00";
			when C1 => cnt <= "01";
			when C2 => cnt <= "10";
			when C3 => cnt <= "11";
			when others => cnt <= "00";
		end case;
	end process;
end architecture;

