-- VHDL Code for a small RF (Register File) 8 reg each 8bit wide --
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity registerfile8x8 is
port(
A1 : in std_logic_vector(2 downto 0); -- addr port 1 to read reg, reg content goes to RD1
A2 : in std_logic_vector(2 downto 0); -- addr port 2 to read reg, reg content goes to RD2
A3 : in std_logic_vector(2 downto 0); -- addr port 3 to write data in WD3 into register 
WD3 : in std_logic_vector(7 downto 0); -- data to be written into reg specified by A3
WE3 : in STD_LOGIC; -- write enable for A3 and WD3
clk : in STD_LOGIC; -- clock

RD1 : out std_logic_vector(7 downto 0); -- shows reg content of the reg specified by A1 
RD2 : out std_logic_vector(7 downto 0); -- shows reg content of the reg specified by A2 

R0 : out std_logic_vector(7 downto 0); -- Probing additional signals directly to these 
R1 : out std_logic_vector(7 downto 0); -- ports to directly see and check the register content
R2 : out std_logic_vector(7 downto 0); -- of a few registers in simulation instead of using   
R3 : out std_logic_vector(7 downto 0); -- a load instruction for each individual register
R4 : out std_logic_vector(7 downto 0);
R5 : out std_logic_vector(7 downto 0);
R6 : out std_logic_vector(7 downto 0);
R7 : out std_logic_vector(7 downto 0));
end entity;

architecture arch of registerfile8x8 is
----- Signals ----------
	-- 8x8 ram is the reg file 
	-- so totally 8 registers and each reg is 8bit wide
	-- Since 3 bits are used to index the regs in this example (A1/A2/A3), we have 8 regs
	-- x"00' is 00 hexadecimal (that is 00000000 binary) 
	type ram is array (0 to 7) of std_logic_vector(7 downto 0);
	signal regfile : ram := ram'(x"00", x"00", x"00", x"00", x"00", x"00", x"00", x"00");
---------------------------
begin
	-- read data from reg specified by addr A1
	RD1 <= regfile(to_integer(unsigned(A1)));
	-- read data from reg specified by addr A2
	RD2 <= regfile(to_integer(unsigned(A2)));

	process(clk)
	begin
		if (clk'event and clk='1') then
			if(WE3='1') then   -- write enable
				-- write data in WD3 into reg specified by addr A3
				regfile(to_integer(unsigned((A3)))) <= WD3;
			end if;
		end if;
	end process;

----- Additional testing ports --------
	R0 <= regfile(0); -- Probing additional signals directly to these
	R1 <= regfile(1); -- ports to directly see and check the register content
	R2 <= regfile(2); -- of a few registers in simulation instead of using
	R3 <= regfile(3); -- a load instruction for each individual register
	R4 <= regfile(4);
	R5 <= regfile(5);
	R6 <= regfile(6);
	R7 <= regfile(7);
end architecture;

