library ieee;
use ieee.std_logic_1164.all;

entity pipo is
	port(clk	: in std_logic;
	     reset	: in std_logic;
	     reg_in	: in std_logic_vector(7 downto 0);
	     en		: in std_logic;
	     reg_out	: out std_logic_vector(7 downto 0) := x"00");
end entity;

architecture arch of pipo is
begin
	reg_proc : process(clk, reset)
	begin
		if(reset = '1') then
			reg_out <= x"00";
		elsif(rising_edge(clk)) then
			if(en='1') then
				reg_out <= reg_in;
			end if;
		end if;
	end process;
end architecture;
