library ieee;
use ieee.std_logic_1164.all;

-- Sequenza da riconoscere: "1001"
entity ese1 is
    port(
		------ YOUR CODE HERE -----------
    		clk : in std_logic;
    		reset : in std_logic;
    		i : in std_logic;
    		o : out std_logic
                ---------------------------------
    );
end entity;

architecture arch of ese1 is

    -- definizione insieme degli stati
    type state is (S0, S1, S2, S3, S4);
    -- S0: Stato iniziale (Nessun match)
    -- S1: Riconosciuto "1"
    -- S2: Riconosciuto "10"
    -- S3: Riconosciuto "100"
    -- S4: Riconosciuto "1001" (Stato finale / Match)

    -- dichiarazione segnali interni
        -- current_state: di tipo state, inizializzato a S0, next_state: di tipo state
	------- YOUR CODE HERE -----------
	signal current_state : state := S0;
	signal next_state : state;
	---------------------------------- 
begin
    --- tecnica di descrizione VHDL : processo multiplo.
    --- 1) Processo per state memory (gestione reset asincrono / e GENERICO avanzamento in corris-
    ---    pondenza del fronte di SALITA del segnale di clock). 
	state_memory : process (clk, reset) 
	begin
	------- YOUR CODE HERE -----------
	if(reset = '1') then
		current_state <= S0;
	elsif(rising_edge(clk)) then
		current_state <= next_state;
	end if;
	---------------------------------- 
	end process;

    --- 2) Logica di stato prossimo 
    
    	next_state_logic : process(current_state, i)
    	begin
	------- YOUR CODE HERE -----------
	case current_state is
		when S0 => if(i = '1') then
				next_state <= S1;
			else
				next_state <= S0;
			end if;
		when S1 => if(i = '1') then
				next_state <= S1;
			else
				next_state <= S2;
			end if;
		when S2 => if(i = '1') then
				next_state <= S1;
			else
				next_state <= S3;
			end if;
		when S3 => if(i = '1') then
				next_state <= S4;
			else
				next_state <= S0;
			end if;
		when S4 => if(i = '1') then
				next_state <= S4;
			else
				next_state <= S1;
			end if;
	end case;
	---------------------------------- 
    	end process next_state_logic;
   
    --- 3) Logica di output 
    --- NBB: 
	-- La FSM e' di tipo Moore (output dipende SOLO da stato corrente)
    	-- AND
	-- Viene emesso il valore '1' SOLO in corrispondenza di un unico stato
	-- Realizzate gestione logica di output *** OUT OF PROCESS! ***

	----- YOUR CODE HERE -----------------
	o <= '1' when current_state = S4 else '0';	
	--------------------------------------
end architecture;
