library STD;
-- fornisce capacita' di leggere/scrivere file
-- e di convertire/stampare valori di tipo bit
use STD.textio.all;	
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
-- permette di convertire/stampare valori di
-- tipo std_logic e std_logic_vector
use ieee.std_logic_textio.all;

entity seq_det_texttb is
end entity seq_det_texttb;

architecture arch of seq_det_texttb is

    -- 1) component to test
component seq_det is
	port(clk, reset : in std_logic;
	     din : in std_logic;
	     err : out std_logic);
end component;

    -- 2) signal to map to component
 signal clk : std_logic := '1'; 
 signal reset : std_logic := '1';
 signal  din : std_logic := '0';
 signal  err : std_logic := '0';

begin
    -- map signals
    uut : seq_det port map(clk=>clk,
			   reset=> reset,
			   din=>din,
			   err=>err);
    process is
    begin
	    clk <= not clk;
	    wait for 5 ns;
    end process;

    stimulus: process is
	    -- TEXTIO variables : file and current line
	    -- file Fout : TEXT open WRITE_MODE is "TBout.txt"; -- commented. Write on STDOUT!
	    variable current_line : line;
    begin
     -- write your test here
	   -- Report header:
	   -- writing the content of current_line
	   write(current_line, string'("-------------------------------------------------"));
	   writeline(OUTPUT, current_line);	 
	   write(current_line, string'("Beginning test: in (reset, din) out (err)"));
	    -- writing current_line in the output file (Fout)
	   writeline(OUTPUT, current_line);	 
	   write(current_line, string'("-------------------------------------------------"));
	   writeline(OUTPUT, current_line);	 

	   -- Begin stimuli test

	   reset <= '0'; wait for 5 ns;
	   write(current_line, now, UNIT => ns);
	   write(current_line, string'(" reset="));
	   write(current_line, reset);
	   write(current_line, string'(" din="));
	   write(current_line, din);
	   write(current_line, string'(" err="));
	   write(current_line, err);
	   writeline(OUTPUT, current_line);

	   reset <= '1'; wait  for 5 ns;
	   write(current_line, now, UNIT => ns);
	   write(current_line, string'(" reset="));
	   write(current_line, reset);
	   write(current_line, string'(" din="));
	   write(current_line, din);
	   write(current_line, string'(" err="));
	   write(current_line, err);
	   writeline(OUTPUT, current_line);

	   -- triplet 1
	   din <= '1'; wait for 10 ns;
	   write(current_line, now, UNIT => ns);
	   write(current_line, string'(" reset="));
	   write(current_line, reset);
	   write(current_line, string'(" din="));
	   write(current_line, din);
	   write(current_line, string'(" err="));
	   write(current_line, err);
	   writeline(OUTPUT, current_line);
	   din <= '0'; wait for 10 ns;
	   write(current_line, now, UNIT => ns);
	   write(current_line, string'(" reset="));
	   write(current_line, reset);
	   write(current_line, string'(" din="));
	   write(current_line, din);
	   write(current_line, string'(" err="));
	   write(current_line, err);
	   writeline(OUTPUT, current_line);
	   din <= '0'; wait for 10 ns;
	   write(current_line, now, UNIT => ns);
	   write(current_line, string'(" reset="));
	   write(current_line, reset);
	   write(current_line, string'(" din="));
	   write(current_line, din);
	   write(current_line, string'(" err="));
	   write(current_line, err);
	   writeline(OUTPUT, current_line);

	   -- triplet 2
	   din <= '1'; wait for 10 ns;
	   write(current_line, now, UNIT => ns);
	   write(current_line, string'(" reset="));
	   write(current_line, reset);
	   write(current_line, string'(" din="));
	   write(current_line, din);
	   write(current_line, string'(" err="));
	   write(current_line, err);
	   writeline(OUTPUT, current_line);
	   din <= '1'; wait for 10 ns;
	   write(current_line, now, UNIT => ns);
	   write(current_line, string'(" reset="));
	   write(current_line, reset);
	   write(current_line, string'(" din="));
	   write(current_line, din);
	   write(current_line, string'(" err="));
	   write(current_line, err);
	   writeline(OUTPUT, current_line);
	   din <= '1'; wait for 10 ns;
	   write(current_line, now, UNIT => ns);
	   write(current_line, string'(" reset="));
	   write(current_line, reset);
	   write(current_line, string'(" din="));
	   write(current_line, din);
	   write(current_line, string'(" err="));
	   write(current_line, err);
	   writeline(OUTPUT, current_line);

	   -- triplet 3 (error signal triplet + reset)
	   din <= '1'; wait for 10 ns;
	   write(current_line, now, UNIT => ns);
	   write(current_line, string'(" reset="));
	   write(current_line, reset);
	   write(current_line, string'(" din="));
	   write(current_line, din);
	   write(current_line, string'(" err="));
	   write(current_line, err);
	   writeline(OUTPUT, current_line);
	   din <= '1'; wait for 10 ns;
	   write(current_line, now, UNIT => ns);
	   write(current_line, string'(" reset="));
	   write(current_line, reset);
	   write(current_line, string'(" din="));
	   write(current_line, din);
	   write(current_line, string'(" err="));
	   write(current_line, err);
	   writeline(OUTPUT, current_line);
	   reset <= '0'; din <= '1'; wait for 10 ns;
	   write(current_line, now, UNIT => ns);
	   write(current_line, string'(" reset="));
	   write(current_line, reset);
	   write(current_line, string'(" din="));
	   write(current_line, din);
	   write(current_line, string'(" err="));
	   write(current_line, err);
	   writeline(OUTPUT, current_line);

	   -- single bit 
	   reset <= '1'; din <= '0'; wait for 10 ns;
	   write(current_line, now, UNIT => ns);
	   write(current_line, string'(" reset="));
	   write(current_line, reset);
	   write(current_line, string'(" din="));
	   write(current_line, din);
	   write(current_line, string'(" err="));
	   write(current_line, err);
	   writeline(OUTPUT, current_line);
		-- tot simulation time : 120 ns 
    wait;
    end process;
end architecture;
    
