library STD;
use STD.textio.all;
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_textio.all;

entity seq_det is
	port(clk, reset : in std_logic;
	     din : in std_logic;
	     err : out std_logic);
end entity;

architecture arch of seq_det is
     attribute enum_encoding : string; -- user defined
     type state is (start, d0_is_1, d0_not_1, d1_is_1, d1_not_1);
     attribute enum_encoding of state : type is "start d0_is_1 d0_not_1 d1_is_1 d1_not_1";
     signal current_state, next_state : state;
begin
-- PROCESS 1 : state memory :
	state_memory : process(clk, reset)
	variable smpline : line;
	begin
		-- data la struttura ef/elsif/endif current_state viene scritto solo 1 volta.
		if(reset = '0') then
			current_state <= start;
			write(smpline, string'("  (R)current state: ") & state'image(current_state));
			writeline(OUTPUT, smpline);
		elsif(clk'event and clk='1') then
			current_state <= next_state;
			write(smpline, string'("   current state: ") & state'image(current_state));
			writeline(OUTPUT, smpline);
		end if;
	end process;
-- PROCESS 2 : next state logic :
	next_state_logic : process(current_state, din) is
	variable nspline : line;
	begin
		case(current_state) is
			when start => if(din = '1') then
				next_state <= d0_is_1;
			else
				next_state <= d0_not_1;
			end if;
			when d0_is_1 => if(din = '1') then
				next_state <= d1_is_1;
			else
				next_state <= d1_not_1;
			end if;
			when d1_is_1 => next_state  <= start;
			when d0_not_1 => next_state <= d1_not_1;
			when d1_not_1 => next_state <= start;
			when others => next_state <= start;
		end case;
			-- NB: a seconda del timing degli eventi e' possibile che
			-- il valore di next_state sia scritto due volte (vedere sensitivity list)
			write(nspline, string'("   next state: ") & state'image(next_state) & " from event cs/din: ");
			-- event originating the message (per capire quale evento genera write):
			if(current_state'event) then
				write(nspline, string'("T/"));
			else
				write(nspline, string'("F/"));
			end if;
			if(din'event) then
				write(nspline, string'("T"));
			else
				write(nspline, string'("F"));
			end if;
			writeline(OUTPUT, nspline);
	end process;
-- PROCESS 3 : OUTPUT LOGIC
	output_process : process(current_state, din) is
	begin
		case(current_state) is
			when d1_is_1 => if(din = '1') then
				ERR <= '1';
			else
				ERR <= '0';
			end if;
			when others => ERR <= '0';
		end case;	
	end process;
end architecture;
