library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity seq_det_tb is
end entity seq_det_tb;

architecture Behavior of seq_det_tb is

    -- component to test
component seq_det is
port(clk, reset  :  in std_logic;
din  :  in std_logic;
err  :  out std_logic);
end component;

    -- signal to map to component
 signal clk : std_logic := '1'; 
 signal reset : std_logic := '1';
 signal  din : std_logic := '0';
 signal  err : std_logic := '0';

begin
    -- map signals
    uut: seq_det port map ( clk=>clk,
				 reset=> reset,
				din=>din,
				err=>err);

    process is
    begin
	    clk <= not clk;
	    wait for 5 ns;
    end process;

    stimulus: process is
    begin
     -- write your test here
	   reset <= '0'; -- reset the FST in start state
	   wait for 5 ns;
	   reset <= '1';
	   wait  for 5 ns;
	   	-- triplet 1
	   din <= '1';
	   wait for 10 ns;
	   din <= '0';
	   wait for 10 ns;
	   din <= '0';
	   wait for 10 ns;
	   	-- triplet 2
	   din <= '1';
	   wait for 10 ns;
	   din <= '1';
	   wait for 10 ns;
	   din <= '1';
	   wait for 10 ns;
	   	-- triplet 3 (error signal triplet + reset)
	   din <= '1';
	   wait for 10 ns;
	   din <= '1';
	   wait for 10 ns;
	   reset <= '0';
	   din <= '1';
	   wait for 10 ns;
	   	-- single bit 
	   reset <= '1';
	   din <= '0';
	   wait for 10 ns;
		-- tot simulation time : 190 ns 
    wait;
    end process;
end architecture behavior;
    
