library ieee;
use ieee.std_logic_1164.all;

entity seq_det is
	port(clk, reset : in std_logic;
	     din : in std_logic;
	     err : out std_logic);
end entity;

architecture arch of seq_det is
     type state is (start, d0_is_1, d0_not_1, d1_is_1, d1_not_1);
     signal current_state, next_state : state;
begin
-- PROCESS 1 : state memory :
	state_memory : process(clk, reset)
	begin
		if(reset = '0') then
			current_state <= start;
		elsif(clk'event and clk='1') then
			current_state <= next_state;
		end if;
	end process;
-- PROCESS 2 : next state logic :
	next_state_logic : process(current_state, din) is
	begin
		case(current_state) is
			when start => if(din = '1') then
				next_state <= d0_is_1;
			else
				next_state <= d0_not_1;
			end if;
			when d0_is_1 => if(din = '1') then
				next_state <= d1_is_1;
			else
				next_state <= d1_not_1;
			end if;
			when d1_is_1 => next_state  <= start;
			when d0_not_1 => next_state <= d1_not_1;
			when d1_not_1 => next_state <= start;
			when others => next_state <= start;
		end case;
	end process;
-- PROCESS 3 : OUTPUT LOGIC
	output_process : process(current_state, din) is
	begin
		case(current_state) is
			when d1_is_1 => if(din = '1') then
				ERR <= '1';
			else
				ERR <= '0';
			end if;
			when others => ERR <= '0';
		end case;	
	end process;
end architecture;
