library ieee;
use ieee.std_logic_1164.all;

entity moore is
	port(	clk, reset, x : in std_logic;
		y : out std_logic);
end entity;

architecture arch of moore is
	type state is (a,b,c,d);
	-- abbiamo 1 solo segnale di stato. 
	signal z : state;
begin				
	-- cambiandone il valore definiamo il next_state
	process (reset, clk)	
	-- un unico processo che gestisce reset/avanzamento stato
	begin
		if reset = '0' then z <= a;
		elsif(clk'event and clk = '1') then
			case z is 
			-- NB: In process (seq.) .NON si usa with/select ma case!
			-- per OGNI stato modelliamo le transizioni
			when a => if(x='0') then -- STATO a
					z <= a;	-- next_state sara' a se x=0
				 else
					z <= b; -- next_state sara' b se x!=0
				 end if;

			when b => if(x ='0') then -- STATO b
					z <= c;
				 else
					z <= b; 
				 end if;

			when c => if(x='0') then -- STATO c
					z <= d;
				 else
					z <= c;
				 end if;

			when d => if(x='0') then -- STATO d
					z <= d;
				 else
					z <= a;
				 end if;
		end case;
		end if;
end process;
y <= '1' when z=b else '0';
end architecture;
