-- Serial in / serial out register : SISO
library ieee;
use ieee.std_logic_1164.all;

entity siso is
port(
    -- beside values related ports registers usually have a control line enabling them
    -- to be responsive or not to the clock signal. This is clock_enable. We also have
    -- a clock in line. 
    clock_enable, clk, si : in std_logic;	-- serial IN  (read 1 bit at time): si
    so : out std_logic				-- serial OUT (output 1 bit at time): so
);
end siso;

architecture arch of siso is
    -- Registers are usually described using the std_logic_vector type. To keep it simple 
    -- we model a small 8 bit register (but the logic is the same for any register size). 
    signal temp : std_logic_vector (7 downto 0) := x"00";
    begin
	process (clk)
	begin
		if (clk='1' and clock_enable='1') then	
		-- if rising_edge(clock) advance 6 LSBs toward MSB (and overwrite it)
			temp(7 downto 1) <= temp(6 downto 0);
		-- and overwrite the post update LSB using the si line actual value
			temp(0) <= si;
		end if;
	end process;
    -- after process execution is complete output the updated MSB on so line
    so <= temp(7);
end architecture;
