library ieee;
use ieee.std_logic_1164.all;
-- Parallel in/serial out: PISO register with load signal
entity piso is
port(
clk,load : in std_logic;	-- when load=1 the content of pi is bitwise copied into temp 
    pi : in std_logic_vector(7 downto 0);  -- input (8 bit) 
    so : out std_logic);	-- outpit (1 bit)
end entity;

architecture arch of piso is
	signal t : std_logic := '0';			-- 1 bit signal for tmp output operations 
	signal temp : std_logic_vector(7 downto 0); -- 8 bit signal for tmp whole reg operations
    begin
    	process (clk,pi,load)
    	begin
    		if (load='1') then
    			temp(7 downto 0) <= pi(7 downto 0);
    		elsif (clk='1') then
    			t <= temp(7);
    			temp(7 downto 1) <= temp(6 downto 0);
    			temp(0) <= '0';
    		end if;
    	end process;
    so <= t;
end architecture;
